/* - AdvServoPositionListener -
 * Servo position change event handling code
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AdvancedServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.ServoPositionChangeListener;
import com.phidgets.event.ServoPositionChangeEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
/**
 *
 * @author Owner
 */
public class AdvServoPositionListener implements ServoPositionChangeListener{
    
    private JFrame appFrame;
    private JComboBox servoCmb;
    private JTextField actPosTxt;
    private JCheckBox stoppedChk;
    private JCheckBox engagedChk;
    
    /** Creates a new instance of AdvServoPositionListener */
    public AdvServoPositionListener(JFrame appFrame, JComboBox servoCmb, JCheckBox engagedChk, JTextField actPosTxt, JCheckBox stoppedChk)
    {
        this.appFrame = appFrame;
        this.servoCmb = servoCmb;
        this.engagedChk = engagedChk;
        this.actPosTxt = actPosTxt;
        this.stoppedChk = stoppedChk;
    }

    public void servoPositionChanged(ServoPositionChangeEvent servoPositionChangeEvent)
    {
        if(servoPositionChangeEvent.getIndex() == ((Integer)servoCmb.getSelectedItem()).intValue())
        {
            actPosTxt.setText(Double.toString(servoPositionChangeEvent.getValue()));
            try {
                stoppedChk.setSelected(((AdvancedServoPhidget) servoPositionChangeEvent.getSource()).getStopped(servoPositionChangeEvent.getIndex()));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
}
